   float3 VertexLighting(in float Array, in float4 WorldPos, in float3 Normals)
      {
          float4 LightPosition=tex2Dlod(LightDataSampler,float4(Array,0.97265625,0.0,0.0))-WorldPos;
          float4 LightColor=tex2Dlod(LightDataSampler,float4(Array,0.9765625,0.0,0.0));
          float4 LightSpot=tex2Dlod(LightDataSampler,float4(Array,0.98046875,0.0,0.0));
          float Attenuation=length(LightPosition.xyz);
          float3 LightVec=LightPosition.xyz/Attenuation;
          float3 Light=DiffuseLight(LightVec,Normals,LightColor.xyz)*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
          return Light*SpotLight(LightVec,LightSpot.xyz,float2(LightSpot.w,LightColor.w));
      }